# ChatGPT Apps Marketing Starter

Template minimal untuk mencoba **MCP server** dan contoh **Responses API** yang relevan dengan artikel "Cara Bikin App di ChatGPT (DevDay 2025)".

## Fitur
- MCP server sederhana dengan dua tool:
  - `generate_marketing_brief`
  - `generate_lead_magnet_outline`
- Endpoint JSON-RPC pada `/mcp` berbasis Express
- Contoh penggunaan **Responses API** untuk keluaran JSON terstruktur

## Prasyarat
- Node.js 18 atau lebih baru
- Akun OpenAI dan API key bila ingin menjalankan contoh Responses API

## Cara Menjalankan
1. Clone atau ekstrak paket ini, lalu masuk ke folder proyek.
2. Install dependency:
   ```bash
   npm i
   ```
3. Salin `.env.example` ke `.env` dan isi:
   ```
   OPENAI_API_KEY=sk-your-key
   PORT=2091
   ```
4. Jalankan MCP server mode dev:
   ```bash
   npm run dev
   ```
   Server MCP berjalan di `http://localhost:2091/mcp`.

5. **Uji lokal dengan MCP Inspector**:
   ```bash
   npx @modelcontextprotocol/inspector@latest
   ```
   - Masukkan endpoint MCP `http://localhost:2091/mcp`
   - Coba panggil tool `generate_marketing_brief` atau `generate_lead_magnet_outline`

6. **Contoh Responses API** (opsional):
   ```bash
   npm run demo:responses
   ```

> Catatan: Untuk menghubungkan ke ChatGPT melalui developer mode dan connector, ikuti panduan resmi Apps SDK dan pastikan endpoint dapat diakses publik via tunneling seperti `ngrok`.

## Struktur
```
src/
  mcp-server.ts
  examples/
    responses-brief.ts
```

Lisensi: MIT
