import 'dotenv/config';
import OpenAI from 'openai';

async function main() {
  const client = new OpenAI({ apiKey: process.env.OPENAI_API_KEY });
  const schema = {
    type: 'object',
    properties: {
      product: { type: 'string' },
      audience: { type: 'string' },
      keyMessages: { type: 'array', items: { type: 'string' } },
      cta: { type: 'string' }
    },
    required: ['product', 'audience', 'keyMessages', 'cta']
  } as const;

  const resp = await client.responses.create({
    model: 'gpt-4o-mini',
    input: [
      { role: 'user', content: 'Buat brief iklan untuk susu kambing premium, target keluarga muda, gaya bersih dan terpercaya' }
    ],
    response_format: {
      type: 'json_schema',
      json_schema: { name: 'Brief', schema, strict: true }
    }
  });

  // Tampilkan hasil dalam bentuk teks
  const out = resp.output?.[0]?.content?.[0];
  console.log(out?.type === 'output_text' ? out.text : JSON.stringify(resp, null, 2));
}

main().catch(err => {
  console.error(err);
  process.exit(1);
});
